﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Kalend;
using Soneta.Web.Business.App;
using Soneta.Web.Business.Kadry;
using System.Collections.Generic;
using Soneta.Langs;

namespace ASP {

    public partial class Urlopy_Na_Dzien : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";

        public class PrnParams : ContextBase {

            public PrnParams(Context context): base(context) {
                definicja = KalendModule.GetInstance(this).DefinicjeLimitow.UrlopWypoczynkowy;
                stanNaDzień = ((ActualDate)Context[typeof(ActualDate)]).Actual;
                okres = FromTo.Year(stanNaDzień.Year);
            }
                
            FromTo okres;
            [Caption("Raport za okres")]
			[Soneta.Business.Required]
            [Priority(10)]
            public FromTo Okres {
                get { return okres; }
				set {
                    if (value == FromTo.Empty)
                        value = FromTo.All;
					okres = value;
                    OnChanged(EventArgs.Empty);
				}
            }

            Date stanNaDzień;
            [Priority(20)]
            [Caption("Stan na dzień")]
            public Date StanNaDzień {
                get { return stanNaDzień; }
				set {
					stanNaDzień = value;
                    OnChanged(EventArgs.Empty);
				}
            }
                
            DefinicjaLimitu definicja;
            [Caption("Nieobecność")]
			[Soneta.Business.Required]
            [Priority(30)]
            public DefinicjaLimitu Nieobecność {
                get { return definicja; }
                set {
                    definicja = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            public object GetListNieobecność() {
                Soneta.Business.View view = KalendModule.GetInstance(this).DefinicjeLimitow.WgNazwy.CreateView();
                view.Condition &= new FieldCondition.Equal("Naliczanie", NaliczanieLimitu.WypoczynkowyNaGodziny);
                return view;
            }
        }

        PrnParams pars = null;
        [Context(Required = true)]
        public PrnParams Params {
            set { pars = value; }
        } 
		    
	    KalendModule kalend;
	    DefinicjaLimitu definicja;
        Date stanNaDzień;
        FromTo okresRok;
        FromTo okresNie;
        FromTo okresPoz;
	
	    protected void OnContextLoad(Object sender, EventArgs args) {
            stanNaDzień = pars.StanNaDzień;
            okresRok = pars.Okres;
            okresNie = okresRok * new FromTo(Date.MinValue, stanNaDzień);
            if (stanNaDzień < okresRok.To)
                okresPoz = new FromTo(stanNaDzień.AddDays(1), okresRok.To);
            else
                okresPoz = FromTo.Empty;
            kalend = KalendModule.GetInstance(dc);
            definicja = pars.Nieobecność;

            ReportHeader1["ROK"] = okresRok.From.Year.ToString();
            ReportHeader1["DATA"] = stanNaDzień.ToString("yyyy-MM-dd");
            ReportHeader1["DEFINICJA"] = definicja.GetLocalizedNazwa(new System.Globalization.CultureInfo(Str_CultureInfo));

            if (dc.Landscape)
                pracow.Width += 20;
            else
                zaległyW.Visible = urlopW.Visible = false;

		    // Odczytanie listy pracowników podległych z kontekstu
		    Row[] rows = getRows();

		    ArrayList result = new ArrayList();
            foreach (Pracownik prac in rows) {
                PracHistoria ph = prac[stanNaDzień];
                result.Add(ph);
            }
		    Grid1.DataSource = result;
	    }

        private Time WyliczNieobecnosci(PracHistoria ph, FromTo okres, bool uwnz) {
            KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik);
            Time urlop = Time.Zero;

            foreach (OkresNieobecności n in kalk.Nieobecnosci(okres * ph.Etat.OkresZatrudnienia, true)) {
			    if (n.Definicja.Limit == null || definicja == null)
                    continue;            
			    if (n.Definicja.Limit.Guid != definicja.Guid)
                    continue;
                if (uwnz && n.Urlop.Przyczyna != PrzyczynaUrlopu.NaŻądanie)
                    continue;
                Nieobecnosc no = (Nieobecnosc)n;
                if (no.Okres.Days == 1 && no.Norma > Time.Zero)
                    urlop += no.Norma;
                else
                    urlop += kalk.Plan.Norma(n.Okres).Czas;
            }
        
            return urlop;            
        }

        protected void Grid1_BeforeRow(Object sender, Soneta.Web.RowEventArgs args) {
            PracHistoria ph = (PracHistoria)args.Row;

            if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowy ||
                ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowyZaGranicą) {
                args.VisibleRow = false;
                return;
            }
        
            Time korekta = Time.Zero;
            Time zaległy = Time.Zero;
            Time wykorzystany = Time.Zero;
            Time urlopZadanie = Time.Zero;
            Time limit = Time.Zero;
        
            IEnumerable limity = kalend.LimNieobecnosci.WgPracownik[ph.Pracownik, definicja][okresRok];
            Date prev = Date.Empty;
            foreach (LimitNieobecnosci l in limity) {
                if (prev != Date.Empty && prev + 1 < l.Okres.From)
                    if (l.Okres.From > stanNaDzień)
                        break;
                    else {
                        zaległy = Time.Zero;
                        limit = Time.Zero;
                        korekta = Time.Zero;
                        wykorzystany = Time.Zero;
                    }
                else if (l.Okres.From.Month == 1 && l.Okres.From.Day == 1)
                    zaległy = l.PrzeniesienieGodz;
			    limit += l.LimitGodz - l.WykorzystanyPoprzGodz;
                korekta += l.ZmianaGodz;
                wykorzystany += l.WykorzystaneGodz;
                prev = l.Okres.To;
            }

            wykorzystany -= WyliczNieobecnosci(ph, okresPoz, false);
            urlopZadanie = WyliczNieobecnosci(ph, okresNie, true);
            wykorzystany -= urlopZadanie;
        
            zaległy += korekta;
            if (zaległy < Time.Zero) {
                limit += zaległy;
                zaległy = Time.Zero;
            }
        
            Fraction wymiar = ph.Etat.Wymiar;
            if (wymiar == Fraction.Zero)
                wymiar = Fraction.One;

            Time norma = ph.Etat.Kalendarz.NormaDobowa;
            if (norma == Time.Zero)
                norma = new Time(8, 0);

            Time p = Time.Zero;
            zaległyG.EditValue = Wylicz(zaległy, norma, wymiar);
            if (wykorzystany <= zaległy) {
                zaległyW.EditValue = Wylicz(wykorzystany, norma, wymiar);
                zaległyP.EditValue = Wylicz(zaległy - wykorzystany, norma, wymiar);
                p = zaległy - wykorzystany;
                wykorzystany = Time.Zero;
            }
            else {
                zaległyW.EditValue = Wylicz(zaległy, norma, wymiar);
                wykorzystany -= zaległy;
            }
            wykorzystany += urlopZadanie;

            urlopG.EditValue = Wylicz(limit, norma, wymiar);
            urlopW.EditValue = Wylicz(wykorzystany, norma, wymiar);
            urlopP.EditValue = Wylicz(limit - wykorzystany, norma, wymiar);

            p += limit - wykorzystany;
        
            razemP.EditValue = Wylicz(p, norma, wymiar);
        }

        string Wylicz(Time t, Time norma, Fraction wymiar) {
            double d = Soneta.Tools.Math.Round(t / norma / wymiar, 2);
            if (t == Time.Zero && d == 0.0)
                return "";
            return string.Format("{0}/{1}", t, d);
        }

	    private Row[] getRows() {
            IWebUser wu = dc.Context.Login.WebUserOperatingInstance;
            if (wu == null)
                return (Row[])dc[typeof(Row[])];

            List<Pracownik> list = new List<Pracownik>();
            Pracownik[] result = null;

            PodwladniKalkulator kalkPodwladni = new PodwladniKalkulator(dc.Context, wu.Host.ID);

            KadryModule module = KadryModule.GetInstance(dc);
            Soneta.Business.View view = module.Pracownicy.WgNazwiska.CreateView();
            // Warunek dla Etat
            RowCondition rcEtat = kalkPodwladni.FiltrEtatu(pars.Okres, null);
            // Pracownicy, Pracownicy młodociani (etat, umowa)
            view.Condition &= rcEtat;
            // Warunek dla Niezatrudnionych
            kalkPodwladni.UwzgledniajNiezatrudnionych = false;
            // Uwzględnij podwładnych
            IWebUser wo = dc.Context.Login.WebUserInstance;
            view.Condition &= kalkPodwladni.PrzeliczFiltr(wu==wo);
            view.ForceAllRows();
            foreach (Pracownik prac in view)
                list.Add(prac);
            result = list.ToArray();

            return result;
        }
    }
}
